﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class CoffeeMaker : Interactable
{
    public SpriteRenderer spriteRenderer;
    public Sprite onSprite;

    override public bool Interact()
    {
        if (!GameController.instance.HasFlag("Coffee Hint"))
        {
            GameController.instance.AddFlag("Coffee Hint");
        }
        else if (!GameController.instance.HasFlag("Coffee") && !GameController.instance.HasFlag("True Coffee") && GameController.instance.HasFlag("Water") && GameController.instance.HasFlag("Makeshift Filter"))
        {
            if (GameController.instance.HasFlag("Coffee Beans"))
            {
                GameController.instance.RemoveFlag("Water");
                GameController.instance.AddFlag("Coffee");
                GameController.instance.StartDialog(new string[] { "The smell of coffee makes Richard lower his guard.", "You have learned some valuable information.", "INFO: You have acquired a clue, you can now leave the apartment through the front door, or, you can keep investigating." }, () =>
                {
                    GameController.instance.ResetHazardCounter();
                });
                spriteRenderer.sprite = onSprite;
                return true;
            }

            if (GameController.instance.HasFlag("True Coffee Beans"))
            {
                GameController.instance.RemoveFlag("Water");
                GameController.instance.AddFlag("True Coffee");
                GameController.instance.StartDialog(new string[] { "The smell of coffee makes Richard lower his guard a lot.", "You have learned some valuable information." }, () =>
                {
                    GameController.instance.ResetHazardCounter();
                });
                spriteRenderer.sprite = onSprite;
                return true;
            }

            if (GameController.instance.HasFlag("Wrong Coffee Beans"))
            {
                GameController.instance.StartDialog(new string[] { "Richard seems to disagree with your choice of blends." });
                return true;
            }

            GameController.instance.StartDialog(new string[] { "You only need the coffee grains.", "Richard was thinking about a special blend he ordered online, it should have arrived in the mail today." });
            return true;
        }

        if (GameController.instance.HasFlag("Coffee") || GameController.instance.HasFlag("True Coffee"))
        {
            GameController.instance.StartDialog(new string[] { "It's a coffee maker." });
        }
        else
        {
            GameController.instance.StartDialog(new string[] { "It's a coffee maker.", "To make coffee you will need some water and coffee beans", "The machine seems to be lacking filters too." });
        }
        return true;
    }
}
